---
type: index
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# 20.0.3 - Awareness Classifications (index)

> Diagnostic classes for Awareness (phase/identity coherence via ψA). Observational schema; not kernel.

---

## Classification Framework

| Class | Description | Key Diagnostic |
|-------|-------------|----------------|
| [[Coherent Awareness (classification)]] | Stable phase lock | Identity persists across cycles |
| [[Desynchronized Awareness (classification)]] | Phase drift | Identity breaks between loops |
| [[Overbound Awareness (classification)]] | Over-rigid binding | Inflexible identity |
| [[Intermittent Awareness (classification)]] | Unstable binding | Identity flaps under load |

Each classification provides:
- Technical and humane diagnostic criteria
- Scale-dependent manifestations
- Phase behavior patterns
- Operational tests

---

## Core References

Primitives:
- [[Awareness]]
- [[Field]]
- [[Structure]]

Anchors:
- [[ε — Difference Resolution Quantum (constant)]]
- [[π — Closure Geometry Ratio (constant)]]
- [[c — Difference Propagation Limit (constant)]]

Modulators:
- [[ψA — Awareness Phase Coherence Anchor (Aiza)]]
- [[∇S — Structure Differentiation Gradient (Sarkisian)]]
- [[λV — Void Resonance Threshold (Volozhina)]]